<?php
// Configura la visualización de errores para la depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuración de la base de datos MySQL
$servername = "localhost"; // Reemplaza esto con el nombre de host de tu servidor
$username = "b100even_invites"; // Reemplaza esto con el usuario de tu base de datos
$password = "BuqL)Kl(+Rk9"; // Reemplaza esto con la contraseña de tu base de datos
$dbname = "b100even_coctelco";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Lógica de filtrado de datos
    $whereClause = '';
    $params = [];
    if (isset($_GET['filter']) && in_array($_GET['filter'], ['solo', 'acompañado',])) {
        $whereClause = " WHERE tipo_asistente = ?";
        $params[] = $_GET['filter'];
    }

    $stmt = $conn->prepare("SELECT nombre, apellido, empresa, telefono, email, tipo_asistente FROM rsvpsfuerzabruta" . $whereClause);
    $stmt->execute($params);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Si se solicita la exportación a Excel
    if (isset($_GET['export']) && $_GET['export'] == 'excel') {
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="asistencias.xls"');
        
        // Genera el contenido de la tabla HTML para el archivo XLS
        $html = '<table>';
        $html .= '<tr><th>Orden</th><th>Nombre</th><th>Apellido</th><th>Empresa</th><th>Telefono</th><th>Email</th><th>Tipo</th></tr>';
        
        foreach ($results as $index => $row) {
            $html .= '<tr>';
            $html .= '<td>' . ($index + 1) . '</td>';
            $html .= '<td>' . htmlspecialchars($row['nombre']) . '</td>';
            $html .= '<td>' . htmlspecialchars($row['apellido']) . '</td>';
            $html .= '<td>' . htmlspecialchars($row['empresa']) . '</td>';
            $html .= '<td>' . htmlspecialchars($row['telefono']) . '</td>';
            $html .= '<td>' . htmlspecialchars($row['email']) . '</td>';
            $html .= '<td>' . htmlspecialchars($row['tipo_asistente']) . '</td>';
            $html .= '</tr>';
        }
        $html .= '</table>';
        
        echo $html;
        exit;
    }

    

    // Si no se solicita la exportación, devuelve los datos en formato JSON
    header('Content-Type: application/json');
    echo json_encode($results);

} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(array("error" => "Error en la base de datos: " . $e->getMessage()));
}
$conn = null;
?>
